#include <iostream>
#include <cmath>

uint8_t MergeDigits(uint8_t left, uint8_t right) {
    return left == right ? 10 * left + left : std::max(left, right); 
}
uint64_t Collision(uint32_t left, uint32_t right) {
    if (!(left * right)) {
        return std::max(left, right);
    }
    uint8_t lowResult = MergeDigits(left % 10, right % 10);
    return lowResult + (0 < lowResult && lowResult < 10 ? 10 : 100) * Collision(left / 10, right / 10);
}
void OptimiseIO() {
    std::ios_base::sync_with_stdio(false);
    std::cout.tie(0);
    std::cerr.tie(0);
    std::cin.tie(0);
}

int main() {
    OptimiseIO();
    uint32_t x;
    uint32_t y;
    std::cin >> x >> y;
    std::cout << Collision(x, y) << std::endl;
    return 0;
}